#!/usr/bin/perl

# last updated for 1.17.1

sub printslab {
	print "diag: $_[0], $_[1] @ stb_$_[1].json\n";
	open FH, '>', "data/sterlcraft/recipes/stb_$_[1].json" or die $!;
	print FH
'{
	"type": "crafting_shaped",
	"group": "slabtoblock",
	"pattern": [
		"#",
		"#"
	],
	"key": {
		"#": {
			"item": "minecraft:' . $_[0] . '_slab"
		}
	},
	"result": {
		"item": "minecraft:' . $_[1] . '"
	}
}';
	close FH;
}

sub printslab_diag {
	print "diag: $_[0], $_[1] @ stb_$_[1].json\n";
	open FH, '>', "data/sterlcraft/recipes/stb_$_[1].json" or die $!;
	print FH
'{
	"type": "crafting_shaped",
	"group": "slabtoblock",
	"pattern": [
		"# ",
		" #"
	],
	"key": {
		"#": {
			"item": "minecraft:' . $_[0] . '_slab"
		}
	},
	"result": {
		"item": "minecraft:' . $_[1] . '"
	}
}';
	close FH;
}

sub printadv {
	print "advc: $_[0] @ stb_$_[1].json\n";
	open FH, '>', "data/sterlcraft/advancements/stb_$_[1].json" or die $!;
	print FH
'{
	"parent": "minecraft:recipes/root",
	"rewards": {
		"recipes": [
			"sterlcraft:stb_' . $_[1] .'"
		]
	},
	"criteria": {
		"has_' . $_[0] . '_slab": {
			"trigger": "minecraft:inventory_changed",
			"conditions": {
				"items": [
					{
						"items": [
							"minecraft:' . $_[0] . '_slab"
						]
					}
				]
			}
		},
		"has_the_recipe": {
			"trigger": "minecraft:recipe_unlocked",
			"conditions": {
				"recipe": "sterlcraft:stb_' . $_[1] . '"
			}
		}
	},
	"requirements": [
		[
			"has_' . $_[0] . '_slab",
			"has_the_recipe"
		]
	]
}';
	close FH;
}

my @stones = (
	'stone',
	'smooth_stone',
	'cobblestone',
	'mossy_cobblestone',
	'andesite',
	'polished_andesite',
	'diorite',
	'polished_diorite',
	'cut_sandstone',
	'cut_red_sandstone',
	'prismarine',
	'dark_prismarine',
	'smooth_quartz',
	'blackstone',
	'polished_blackstone',
	'cut_copper',
	'exposed_cut_copper',
	'weathered_cut_copper',
	'oxidized_cut_copper',
	'waxed_cut_copper',
	'waxed_exposed_cut_copper',
	'waxed_weathered_cut_copper',
	'waxed_oxidized_cut_copper',
	'cobbled_deepslate',
	'polished_deepslate'
);

foreach my $item (@stones) {
	printslab($item, $item);
	printadv($item, $item);
}

my @stonediag = (
	'sandstone',
	'red_sandstone'
);

foreach my $item (@stonediag) {
	printslab_diag($item, $item);
	printadv($item, $item);
}

printslab_diag('stone_brick', 'stone_bricks');
printadv('mossy_stone_brick', 'mossy_stone_bricks');
printslab_diag('quartz', 'quartz_block');
printadv('quartz', 'quartz_block');
printslab_diag('quartz', 'quartz_block');
printadv('quartz', 'quartz_block');
printslab('smooth_quartz', 'smooth_quartz_block');
printadv('smooth_quartz', 'smooth_quartz_block');
printslab_diag('purpur', 'purpur_block');
printadv('purpur', 'purpur_block');

my @bricks = (
	'brick',
	'prismarine_brick',
	'nether_brick',
	'red_nether_brick',
	'end_stone_brick',
	'polished_blackstone_brick',
	'deepslate_brick',
	'deepslate_tile'
);

foreach my $item (@bricks) {
	printslab($item, $item . 's');
	printadv($item, $item . 's');
}

my @planks = (
	'oak',
	'spruce',
	'birch',
	'jungle',
	'acacia',
	'dark_oak',
	'crimson',
	'warped'
);

foreach my $item (@planks) {
	printslab($item, $item . '_planks');
	printadv($item, $item . '_planks');
}
